# تحليل المشروع - Project Analysis

## نظرة عامة - Overview

هذا المشروع مبني باستخدام **Laravel Framework 11** مع PHP 8.2+

## اللغات والتقنيات المستخدمة

### Backend (الخلفية):
- **PHP 8.2+** - لغة البرمجة الرئيسية
- **Laravel Framework 11.9** - إطار العمل الرئيسي
- **MySQL/MariaDB** - قاعدة البيانات (مفترضة من بنية Laravel)

### Frontend (الواجهة الأمامية):
- **JavaScript** - لغة البرمجة الأساسية
- **Vite 5.0** - أداة البناء والتجميع
- **Tailwind CSS 3.1** - إطار عمل CSS
- **Alpine.js 3.4** - مكتبة JavaScript خفيفة
- **Axios 1.6** - للطلبات HTTP
- **Blade Templates** - نظام القوالب الخاص بـ Laravel

### المكتبات والإضافات الرئيسية:

#### أنظمة الدفع (Payment Systems):
- Stripe
- PayPal
- Mollie
- PayTM
- Authorize.Net
- Braintree
- CoinGate
- Midtrans
- PayPay
- YooMoney/YooKassa
- FedaPay
- PhonePe
- Xendit

#### إدارة المستخدمين والصلاحيات:
- Laravel Sanctum (للـ API Authentication)
- Laratrust (للصلاحيات والأدوار)
- Laravel Socialite (للـ OAuth)
- Google2FA (للـ Two-Factor Authentication)
- Laravel Impersonate

#### الاتصالات (Communications):
- Twilio (SMS)
- Vonage/Nexmo (SMS)
- Kavenegar
- Mailchimp
- Laravel IMAP

#### قواعد البيانات والتقارير:
- Yajra DataTables (للجداول التفاعلية)
- Maatwebsite Excel
- PhpSpreadsheet

#### التخزين السحابي:
- AWS S3
- Dropbox
- Box

#### ميزات أخرى:
- Chatify (نظام الدردشة)
- Laravel Cashier (Paddle)
- Google Calendar Integration
- OpenAI Integration
- Microsoft Graph API

## بنية المشروع - Project Structure

```
main-file/
├── app/                    # الكود الرئيسي للتطبيق
│   ├── Classes/           # الفئات المساعدة
│   ├── Console/           # أوامر Artisan
│   ├── DataTables/        # جداول البيانات
│   ├── Events/            # الأحداث (Events)
│   ├── Http/
│   │   ├── Controllers/   # المتحكمات (Controllers)
│   │   ├── Middleware/    # Middleware
│   │   └── Requests/      # طلبات التحقق (Validation)
│   ├── Listeners/         # المستمعون للأحداث
│   ├── Mail/              # قوالب البريد الإلكتروني
│   ├── Models/            # نماذج قاعدة البيانات
│   └── Providers/         # Service Providers
├── bootstrap/             # ملفات التهيئة
├── config/                # ملفات الإعدادات
├── database/
│   ├── migrations/        # Migrations
│   ├── seeders/          # Seeders
│   └── factories/        # Factories
├── public/                # الملفات العامة (نقطة الدخول)
├── resources/
│   ├── css/              # ملفات CSS
│   ├── js/               # ملفات JavaScript
│   ├── lang/             # ملفات الترجمة (متعدد اللغات)
│   └── views/            # قوالب Blade
├── routes/                # ملفات المسارات (Routes)
│   ├── web.php           # مسارات الويب
│   ├── api.php           # مسارات API
│   └── auth.php          # مسارات المصادقة
├── storage/               # ملفات التخزين
├── tests/                 # الاختبارات
├── vendor/                # المكتبات الخارجية (Composer)
├── packages/              # حزم مخصصة (workdo)
├── composer.json          # تبعيات PHP
├── package.json           # تبعيات JavaScript
├── vite.config.js         # إعدادات Vite
└── artisan                # أداة سطر الأوامر Laravel
```

## طريقة البناء والتشغيل - Build Process

### 1. تثبيت التبعيات (Install Dependencies):

```bash
# تثبيت تبعيات PHP
composer install

# تثبيت تبعيات JavaScript
npm install
```

### 2. إعداد البيئة (Environment Setup):

```bash
# نسخ ملف البيئة
cp .env.example .env

# توليد مفتاح التطبيق
php artisan key:generate

# تشغيل Migrations
php artisan migrate

# (اختياري) ملء قاعدة البيانات ببيانات تجريبية
php artisan db:seed
```

### 3. بناء الأصول (Build Assets):

```bash
# للتطوير (Development)
npm run dev

# للإنتاج (Production)
npm run build
```

### 4. تشغيل المشروع (Run Project):

```bash
# تشغيل خادم التطوير
php artisan serve

# أو استخدام Laravel Sail (Docker)
./vendor/bin/sail up
```

## الميزات الرئيسية - Main Features

بناءً على تحليل الكود، يبدو أن هذا التطبيق يتضمن:

1. **نظام إدارة الفواتير (Invoice Management)**
2. **نظام العروض (Proposals)**
3. **نظام المشتريات (Purchases)**
4. **نظام المستودعات (Warehouses)**
5. **نظام إدارة المستخدمين والأدوار (Users & Roles)**
6. **نظام الخطط والاشتراكات (Plans & Subscriptions)**
7. **نظام الكوبونات (Coupons)**
8. **نظام الدعم الفني (Helpdesk/Support)**
9. **نظام الإحالة (Referral Program)**
10. **نظام الدردشة (Chat)**
11. **نظام الإشعارات (Notifications)**
12. **نظام البريد الإلكتروني (Email Templates)**
13. **متعدد اللغات (Multi-language)**
14. **متعدد Workspaces**

## ملاحظات مهمة - Important Notes

1. **Laravel 11**: أحدث إصدار من Laravel مع بنية محسّنة
2. **Packages Custom**: يحتوي على حزم مخصصة في مجلد `packages/workdo/`
3. **Multi-tenant**: يبدو أن التطبيق يدعم Workspaces متعددة
4. **Payment Gateway Integration**: تكامل مع العديد من بوابات الدفع
5. **Modular Structure**: بنية معيارية مع Events و Listeners

## كيفية إضافة ميزات جديدة - How to Add New Features

### لإضافة ميزة جديدة:

1. **إنشاء Migration** (إذا كانت تحتاج جدول جديد):
   ```bash
   php artisan make:migration create_feature_name_table
   ```

2. **إنشاء Model**:
   ```bash
   php artisan make:model FeatureName
   ```

3. **إنشاء Controller**:
   ```bash
   php artisan make:controller FeatureNameController
   ```

4. **إضافة Routes** في `routes/web.php` أو `routes/api.php`

5. **إنشاء Views** في `resources/views/feature_name/`

6. **إضافة JavaScript/CSS** إذا لزم الأمر في `resources/js/` و `resources/css/`

7. **بناء الأصول**:
   ```bash
   npm run dev
   ```

## الترجمة - Translation

المشروع يدعم العديد من اللغات:
- العربية (ar)
- الإنجليزية (en)
- الفرنسية (fr)
- الألمانية (de)
- الإسبانية (es)
- الإيطالية (it)
- اليابانية (ja)
- الهولندية (nl)
- البولندية (pl)
- البرتغالية (pt)
- الروسية (ru)
- التركية (tr)
- الدنماركية (da)
- العبرية (he)
- الصينية (zh)

---

**تاريخ التحليل**: $(Get-Date -Format "yyyy-MM-dd")
**إصدار Laravel**: 11.9
**إصدار PHP المطلوب**: ^8.2

