# قائمة فحص سريعة - Quick Test Checklist

## ✅ فحص سريع للنظام

### 1. فحص الملفات الأساسية

#### Migrations ✅
- [ ] `2025_01_15_000001_create_courier_companies_table.php`
- [ ] `2025_01_15_000002_create_sellers_table.php`
- [ ] `2025_01_15_000003_create_shipment_orders_table.php`
- [ ] `2025_01_15_000004_create_shipment_items_table.php`
- [ ] `2025_01_15_000005_create_stock_locations_table.php`
- [ ] `2025_01_15_000006_create_shipment_items_master_table.php`
- [ ] `2025_01_15_000007_create_shipment_inventory_table.php`
- [ ] `2025_01_15_000008_create_shipment_vehicles_table.php`
- [ ] `2025_01_15_000009_create_shipment_boxes_table.php`

#### Models ✅
- [ ] `CourierCompany.php`
- [ ] `Seller.php`
- [ ] `ShipmentOrder.php`
- [ ] `ShipmentItem.php`
- [ ] `StockLocation.php`
- [ ] `ShipmentItemMaster.php`
- [ ] `ShipmentInventory.php`
- [ ] `ShipmentVehicle.php`
- [ ] `ShipmentBox.php`

#### Controllers ✅
- [ ] `ShipmentOrderController.php`
- [ ] `CourierCompanyController.php`
- [ ] `SellerController.php`
- [ ] `StockLocationController.php`
- [ ] `ShipmentItemController.php`
- [ ] `ShipmentInventoryController.php`
- [ ] `VehicleController.php`
- [ ] `BoxController.php`

#### Routes ✅
- [ ] Routes موجودة في `routes/web.php`
- [ ] جميع Routes مسجلة

#### Views ✅
- [ ] جميع Views موجودة في `resources/views/shipment/`

### 2. خطوات الاختبار السريع

#### الخطوة 1: تشغيل Migrations
```bash
php artisan migrate
```
**المتوقع**: ✅ نجاح - إنشاء 9 جداول

#### الخطوة 2: إضافة الصلاحيات
```bash
php artisan db:seed --class=ShipmentPermissionSeeder
```
**المتوقع**: ✅ نجاح - إضافة 33 صلاحية

#### الخطوة 3: التحقق من Routes
```bash
php artisan route:list | findstr shipment
```
**المتوقع**: ✅ يجب أن تظهر 8 routes

#### الخطوة 4: تسجيل الدخول والتحقق
1. سجل الدخول
2. تحقق من ظهور "Shipment Management" في القائمة
3. افتح كل صفحة للتأكد من عدم وجود أخطاء

### 3. اختبارات سريعة (5 دقائق)

#### اختبار 1: إنشاء شركة شحن
1. اذهب إلى: `/courier-companies/create`
2. أدخل: Name = "Test Company"
3. احفظ
**المتوقع**: ✅ يجب أن يعمل

#### اختبار 2: إنشاء بائع
1. اذهب إلى: `/sellers/create`
2. أدخل: Name = "Test Seller"
3. احفظ
**المتوقع**: ✅ يجب أن يعمل

#### اختبار 3: إنشاء طلب
1. اذهب إلى: `/shipment-orders/create`
2. أدخل بيانات العميل
3. اختر الشركة والبائع
4. احفظ
**المتوقع**: ✅ يجب أن يعمل + رقم طلب تلقائي

#### اختبار 4: عرض القوائم
1. افتح كل صفحة index
2. تحقق من عدم وجود أخطاء
**المتوقع**: ✅ جميع الصفحات تعمل

### 4. الأخطاء الشائعة

#### ❌ خطأ: Class 'App\Models\X' not found
**الحل**: 
```bash
composer dump-autoload
```

#### ❌ خطأ: View [shipment.xxx.index] not found
**الحل**: تحقق من وجود الملف في `resources/views/shipment/xxx/index.blade.php`

#### ❌ خطأ: Route [xxx.index] not defined
**الحل**: 
```bash
php artisan route:clear
php artisan cache:clear
```

#### ❌ خطأ: Permission denied
**الحل**: 
```bash
php artisan db:seed --class=ShipmentPermissionSeeder
```

### 5. التحقق من الكود

#### Syntax Errors
- ✅ تم فحص جميع الملفات بـ Linter
- ✅ لا توجد أخطاء syntax

#### Namespaces
- ✅ جميع Namespaces صحيحة
- ✅ جميع Use statements موجودة

#### Relationships
- ✅ العلاقات محددة في Models
- ✅ Foreign Keys موجودة في Migrations

## 🎯 النتيجة المتوقعة

إذا اتبعت جميع الخطوات:
- ✅ النظام يجب أن يعمل بدون أخطاء
- ✅ جميع الصفحات يجب أن تعمل
- ✅ جميع العمليات CRUD يجب أن تعمل
- ✅ الصلاحيات يجب أن تعمل

## 📝 ملاحظات

1. **أول مرة**: قد تحتاج لتشغيل `composer dump-autoload`
2. **Cache**: قد تحتاج لمسح Cache بعد التعديلات
3. **Permissions**: تأكد من ربط الصلاحيات بالمستخدمين
4. **Workspace**: تأكد من وجود Workspace نشط

---

**للاختبار الكامل**: راجع `TESTING_GUIDE.md`

