# دليل الصلاحيات والقائمة - Permissions and Menu Guide

## ✅ ما تم إنجازه

### 1. Seeder للصلاحيات ✅
تم إنشاء `database/seeders/ShipmentPermissionSeeder.php` لإضافة جميع الصلاحيات المطلوبة:

**الصلاحيات المضافة:**
- `shipment order manage`
- `shipment order create`
- `shipment order edit`
- `shipment order delete`
- `shipment order show`
- `courier company manage`
- `courier company create`
- `courier company edit`
- `courier company delete`
- `seller manage`
- `seller create`
- `seller edit`
- `seller delete`

### 2. عناصر القائمة ✅
تم إضافة عناصر القائمة في `app/Listeners/CompanyMenuListener.php`:

**القائمة المضافة:**
- Shipment Management (القائمة الرئيسية)
  - Shipment Orders
  - Courier Companies
  - Sellers

## 🚀 كيفية التفعيل

### 1. تشغيل Seeder الصلاحيات

```bash
php artisan db:seed --class=ShipmentPermissionSeeder
```

أو يمكنك إضافة هذا السطر في `database/seeders/DatabaseSeeder.php`:

```php
$this->call([
    // ... other seeders
    ShipmentPermissionSeeder::class,
]);
```

ثم تشغيل:
```bash
php artisan db:seed
```

### 2. التأكد من تشغيل Migrations

```bash
php artisan migrate
```

### 3. التحقق من الصلاحيات

بعد تشغيل Seeder، يمكنك التحقق من الصلاحيات عبر:
- واجهة إدارة الصلاحيات في النظام
- أو مباشرة في قاعدة البيانات (جدول `permissions`)

### 4. التحقق من القائمة

بعد تسجيل الدخول، يجب أن تظهر قائمة "Shipment Management" في القائمة الجانبية مع العناصر الفرعية.

## 📝 ملاحظات مهمة

1. **الصلاحيات تُضاف تلقائياً** لـ Super Admin و Company Role
2. **القائمة تظهر فقط** للمستخدمين الذين لديهم الصلاحية `shipment order manage`
3. **يمكن تخصيص الصلاحيات** لكل مستخدم أو دور عبر واجهة النظام

## 🔧 استكشاف الأخطاء

### إذا لم تظهر القائمة:
1. تأكد من تشغيل Seeder الصلاحيات
2. تأكد من أن المستخدم لديه الصلاحية `shipment order manage`
3. تأكد من تسجيل الخروج والدخول مرة أخرى (لإعادة تحميل القائمة)

### إذا لم تعمل الصلاحيات:
1. تأكد من تشغيل Seeder
2. تحقق من جدول `permissions` في قاعدة البيانات
3. تحقق من جدول `permission_role` للتأكد من ربط الصلاحيات بالأدوار

---

**التاريخ**: 2025-01-15
**الحالة**: ✅ جاهز للاستخدام

