# نظام إدارة الشحنات - Shipment Management System Documentation

## نظرة عامة

هذا المستند يوضح البنية الكاملة لنظام إدارة الشحنات الذي يحتاج إلى إضافته للمشروع.

## الجداول الأساسية المطلوبة (Database Tables)

### 1. شركات الشحن (Courier Companies)
- `courier_companies`
- Fields: name, contact_person, phone, email, address, status, workspace, created_by

### 2. طلبات الشحن (Shipment Orders)
- `shipment_orders`
- Fields: order_number, customer_name, customer_phone, customer_email, customer_address, delivery_address, order_status, courier_company_id, seller_id, total_amount, payment_status, workspace, created_by

### 3. عناصر الشحنة (Shipment Items)
- `shipment_items`
- Fields: shipment_order_id, item_name, sku, quantity, weight, price, workspace, created_by

### 4. مواقع المخزون (Stock Locations)
- `stock_locations`
- Fields: warehouse_id, location_code, shelf_code, zone, workspace, created_by

### 5. المركبات (Vehicles)
- `shipment_vehicles`
- Fields: vehicle_number, vehicle_type, driver_name, driver_phone, status, workspace, created_by

### 6. الصناديق (Boxes)
- `shipment_boxes`
- Fields: box_number, box_type, dimensions, weight_capacity, status, workspace, created_by

### 7. البيانيات (Manifests)
- `shipment_manifests`
- Fields: manifest_number, manifest_date, vehicle_id, driver_id, status, total_orders, workspace, created_by

### 8. التذاكر (Tickets)
- `shipment_tickets`
- Fields: ticket_number, shipment_order_id, manifest_id, issue_type, description, status, workspace, created_by

### 9. البائعون (Sellers)
- `sellers`
- Fields: name, email, phone, address, company_name, status, workspace, created_by

### 10. المسارات (Routes)
- `shipment_routes`
- Fields: route_name, origin_location_id, destination_location_id, distance, estimated_time, status, workspace, created_by

### 11. المواقع (Delivery Locations)
- `delivery_locations`
- Fields: location_name, city, state, country, zip_code, coordinates, workspace, created_by

### 12. المخزون (Inventory)
- `shipment_inventory`
- Fields: item_sku, item_name, warehouse_id, stock_location_id, quantity, reserved_quantity, min_stock_level, workspace, created_by

### 13. العروض (Bundle Offers)
- `bundle_offers`
- Fields: offer_name, description, start_date, end_date, discount_type, discount_value, status, workspace, created_by

### 14. التقارير المالية (Finance)
- `shipment_invoices`
- Fields: invoice_number, shipment_order_id, invoice_date, amount, tax, total_amount, payment_status, workspace, created_by

### 15. الأسئلة الشائعة (FAQ)
- `shipment_faqs`
- Fields: question, answer, category, order, status, workspace, created_by

## الحالات (Statuses) للطلبات

```
ORDER GENERATED → ORDER CREATED → PICK LIST → PACKED → DISPATCHED → DELIVERY → MANIFEST → DELIVERED → RETURNED
```

## الوحدات الرئيسية (Modules)

### 1. إعدادات الشركة (Company Details)
- إعدادات الشركة الافتراضية
- معلومات الاتصال
- سياسة الخصوصية
- الشروط والأحكام

### 2. التكامل (Integration)
- تكامل Zid
- تكامل Salla
- تكامل CITC
- إعدادات SMS
- إعدادات تطبيق Salla
- إعدادات تطبيق Zid

### 3. إدارة الشحنات (Shipment Management)
- جميع الطلبات
- Bulk Forward - 3PL
- Manual Forward - 3PL
- الطلبات المرتجعة
- إنشاء طلب مرتجع
- إلغاء الطلبات - 3PL
- طباعة جماعية
- Forward Remove
- الطلبات المحذوفة
- الطلبات الملغاة
- طلبات Salla المعلقة
- تعيين الشحنات
- قائمة طلبات Zid
- إنشاء طلب جماعي (BETA)
- تحديث التاريخ الجماعي

### 4. إدارة المخزون (Inventory Management)
- إضافة عنصر للمخزون
- عرض عناصر المخزون
- إضافة رف
- عرض الرفوف
- تحديث الرف
- دمج المخزون
- المخزون لكل عميل
- رفع المخزون
- إدارة مواقع المخزون
- إدارة العناصر

### 5. إدارة المركبات (Vehicle Management)
- إضافة مركبة
- قائمة المركبات

### 6. إدارة الصناديق (Box Management)
- إضافة صندوق
- قائمة الصناديق

### 7. إدارة المرتجعات (Return Management)
- عرض العناصر التالفة
- قائمة الطلبات المرتجعة

### 8. إدارة المستودعات (Warehouse Management)
- إنشاء Tods
- عرض Todd
- إضافة مستودع
- عرض المستودعات

### 9. إدارة البيانيات (Manifest Management)
- بيان جديد
- قائمة الالتقاط
- قائمة البيانيات
- عرض القائمة المعينة
- إدارة البيانيات الجديدة (Beta)

### 10. إدارة التذاكر (Ticket Management)
- القائمة الكاملة
- تذكرة البيان

### 11. إدارة العروض (Offer Management)
- قائمة عروض الحزم
- إضافة عروض حزم جديدة
- قائمة طلبات الحزم

### 12. إدارة المنتقيين (Pickers Management)
- قائمة الالتقاط الفردي
- قائمة الالتقاط الجماعي
- قائمة الالتقاط المكتمل
- إعدادات المنتقي

### 13. إدارة التعبئة (Packaging Management)
- التعبئة
- التعبئة مع Todd

### 14. إدارة الإرسال (Dispatching Management)
- الإرسال
- الإرسال (Beta)
- الإرسال إلى التسليم

### 15. إدارة البائعين (Seller Management)
- إضافة بائع
- عرض جميع البائعين

### 16. إدارة المستخدمين (Users Management)
- عرض جميع المستخدمين
- إضافة مستخدم

### 17. الإدارة المالية (Finance Management)
- تعيين رسوم ثابتة
- تعيين رسوم ديناميكية
- جميع الفئات
- فواتير رسوم التخزين
- تقرير المعاملات
- فاتورة المعدل الثابت
- فاتورة ديناميكية
- جميع أنواع التخزين
- إلغاء الطلب
- إنشاء فاتورة Lm
- عرض فاتورة Lm

### 18. إدارة المسارات (Route Management)
- إضافة مسار
- إضافة مسار جماعي
- عرض المسار

### 19. إدارة خدمات الشحن (Courier Service Management)
- عرض شركة الشحن
- إضافة منطقة
- عرض المناطق
- سجل الشحنات
- سجل التتبع

### 20. إدارة المواقع (Location Management)
- قائمة المواقع
- استيراد المواقع
- استيراد مدينة التسليم
- قائمة شركات التسليم
- إضافة دولة
- إضافة من Master

### 21. الأسئلة الشائعة (FAQ)
- إضافة سؤال
- عرض الأسئلة

### 22. إدارة التقارير (Reports Management)
- تقرير الرفوف
- أعلى منتجات الإرسال
- تقرير OFD
- أداء الموظفين
- تقرير الإرسال
- تقرير 3PL
- تقرير التعبئة
- إجمالي مخزون العناصر
- سجل الواردات
- تاريخ المخزون
- تاريخ مخزون التلف
- تقرير التخزين
- تقرير الشحنة الجماعية

### 23. إدارة الوصول (Access Management)
- قالب جديد
- عرض القالب

## الخطوات التالية للتنفيذ

1. **إنشاء Migrations** لجميع الجداول المطلوبة
2. **إنشاء Models** مع العلاقات بين الجداول
3. **إنشاء Controllers** لجميع الوحدات
4. **إضافة Routes** في routes/web.php
5. **إنشاء Views** باستخدام Blade Templates
6. **إنشاء DataTables** للقوائم
7. **إضافة Permissions** في النظام
8. **إنشاء Events & Listeners** إذا لزم الأمر
9. **إضافة Validation Rules**
10. **إضافة التكاملات الخارجية** (Zid, Salla, CITC)

## ملاحظات مهمة

- جميع الجداول يجب أن تحتوي على `workspace` و `created_by`
- استخدام Laratrust للصلاحيات
- استخدام Yajra DataTables للقوائم
- استخدام Events & Listeners للعمليات المهمة
- اتباع نمط MVC المتبع في المشروع
- استخدام Helper Functions الموجودة (creatorId(), getActiveWorkSpace())

