# دليل الاختبار - Testing Guide

## ✅ خطوات الاختبار الشاملة

### 1. التحقق من قاعدة البيانات

#### أ. تشغيل Migrations
```bash
php artisan migrate
```

**المتوقع:**
- يجب أن تعمل جميع Migrations بنجاح
- يجب إنشاء الجداول التالية:
  - `courier_companies`
  - `sellers`
  - `shipment_orders`
  - `shipment_items`
  - `stock_locations`
  - `shipment_items_master`
  - `shipment_inventory`
  - `shipment_vehicles`
  - `shipment_boxes`

#### ب. التحقق من الجداول
```sql
SHOW TABLES LIKE 'shipment%';
SHOW TABLES LIKE 'courier%';
SHOW TABLES LIKE 'sellers';
SHOW TABLES LIKE 'stock_locations';
```

### 2. إضافة الصلاحيات

```bash
php artisan db:seed --class=ShipmentPermissionSeeder
```

**المتوقع:**
- يجب إضافة 33 صلاحية (13 من المرحلة 1 + 20 من المرحلة 2)
- يجب ربط الصلاحيات بأدوار Super Admin و Company

**التحقق:**
```sql
SELECT * FROM permissions WHERE name LIKE 'shipment%' OR name LIKE 'courier%' OR name LIKE 'seller%' OR name LIKE 'stock%' OR name LIKE 'inventory%' OR name LIKE 'vehicle%' OR name LIKE 'box%';
```

### 3. اختبار Routes

```bash
php artisan route:list | grep shipment
php artisan route:list | grep courier
php artisan route:list | grep seller
php artisan route:list | grep stock-location
php artisan route:list | grep vehicle
php artisan route:list | grep box
```

**المتوقع:**
- يجب أن تظهر جميع Routes التالية:
  - `shipment-orders.*`
  - `courier-companies.*`
  - `sellers.*`
  - `stock-locations.*`
  - `shipment-items.*`
  - `shipment-inventory.*`
  - `vehicles.*`
  - `boxes.*`

### 4. اختبار الواجهات (Views)

#### أ. اختبار صفحة القائمة الرئيسية
1. تسجيل الدخول
2. التحقق من ظهور قائمة "Shipment Management" في القائمة الجانبية
3. التحقق من وجود العناصر الفرعية:
   - Shipment Orders
   - Courier Companies
   - Sellers
   - Items
   - Inventory
   - Stock Locations
   - Vehicles
   - Boxes

#### ب. اختبار CRUD للوحدات

**1. شركات الشحن (Courier Companies):**
- ✅ اختبار `/courier-companies` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء شركة جديدة
- ✅ اختبار تعديل شركة
- ✅ اختبار حذف شركة

**2. البائعون (Sellers):**
- ✅ اختبار `/sellers` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء بائع جديد
- ✅ اختبار تعديل بائع
- ✅ اختبار حذف بائع

**3. مواقع المخزون (Stock Locations):**
- ✅ اختبار `/stock-locations` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء موقع جديد
- ✅ اختبار تعديل موقع
- ✅ اختبار حذف موقع

**4. العناصر (Items):**
- ✅ اختبار `/shipment-items` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء عنصر جديد
- ✅ اختبار تعديل عنصر
- ✅ اختبار حذف عنصر

**5. المخزون (Inventory):**
- ✅ اختبار `/shipment-inventory` - يجب أن تظهر القائمة
- ✅ اختبار إضافة عنصر للمخزون
- ✅ اختبار تعديل المخزون
- ✅ اختبار حذف عنصر من المخزون

**6. المركبات (Vehicles):**
- ✅ اختبار `/vehicles` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء مركبة جديدة
- ✅ اختبار تعديل مركبة
- ✅ اختبار حذف مركبة

**7. الصناديق (Boxes):**
- ✅ اختبار `/boxes` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء صندوق جديد
- ✅ اختبار تعديل صندوق
- ✅ اختبار حذف صندوق

**8. طلبات الشحن (Shipment Orders):**
- ✅ اختبار `/shipment-orders` - يجب أن تظهر القائمة
- ✅ اختبار إنشاء طلب جديد
  - التحقق من توليد رقم الطلب تلقائياً
  - التحقق من إضافة عناصر للطلب
  - التحقق من حساب السعر الإجمالي
- ✅ اختبار عرض الطلب
- ✅ اختبار تعديل الطلب
- ✅ اختبار حذف الطلب

### 5. اختبار الوظائف الخاصة

#### أ. توليد رقم الطلب التلقائي
- إنشاء طلب جديد
- التحقق من وجود رقم طلب فريد
- التنسيق: `SH000001`, `SH000002`, إلخ

#### ب. حساب السعر الإجمالي
- إضافة عناصر للطلب
- التحقق من حساب السعر الإجمالي تلقائياً

#### ج. حساب الكمية المتاحة في المخزون
- إضافة عنصر للمخزون
- التحقق من: `available_quantity = quantity - reserved_quantity`

#### د. حساب حجم الصندوق
- إدخال الأبعاد (الطول، العرض، الارتفاع)
- التحقق من حساب الحجم تلقائياً: `volume = length × width × height`

### 6. اختبار الصلاحيات

#### أ. بدون صلاحيات
- محاولة الوصول للصفحات بدون صلاحية
- **المتوقع**: رسالة "Permission denied"

#### ب. مع صلاحيات
- تسجيل الدخول كمستخدم لديه الصلاحيات
- **المتوقع**: إمكانية الوصول لجميع الصفحات

### 7. اختبار العلاقات بين الجداول

#### أ. طلبات الشحن مع العناصر
- إنشاء طلب جديد
- إضافة عناصر
- **المتوقع**: يجب حفظ العناصر مع الطلب

#### ب. المخزون مع المواقع
- إنشاء موقع مخزون
- إضافة عنصر للمخزون في هذا الموقع
- **المتوقع**: يجب ربط العنصر بالموقع

#### ج. المخزون مع المستودعات
- إنشاء مستودع
- إضافة عنصر للمخزون في هذا المستودع
- **المتوقع**: يجب ربط العنصر بالمستودع

### 8. اختبار Validation

#### أ. الحقول المطلوبة
- محاولة إنشاء سجل بدون الحقول المطلوبة
- **المتوقع**: رسائل خطأ Validation

#### ب. الحقول الفريدة
- محاولة إنشاء SKU مكرر
- محاولة إنشاء رقم مركبة مكرر
- محاولة إنشاء رقم صندوق مكرر
- **المتوقع**: رسائل خطأ "already exists"

### 9. اختبار Workspace Isolation

- إنشاء بيانات في Workspace 1
- تبديل إلى Workspace 2
- **المتوقع**: لا يجب رؤية بيانات Workspace 1

## 🐛 الأخطاء المحتملة وحلولها

### الخطأ 1: Table doesn't exist
**السبب**: لم يتم تشغيل Migrations
**الحل**: `php artisan migrate`

### الخطأ 2: Permission denied
**السبب**: لم يتم إضافة الصلاحيات
**الحل**: `php artisan db:seed --class=ShipmentPermissionSeeder`

### الخطأ 3: Route not found
**السبب**: Routes غير موجودة أو Cache قديم
**الحل**: 
```bash
php artisan route:clear
php artisan cache:clear
```

### الخطأ 4: Class not found
**السبب**: Namespace خاطئ أو Class غير موجود
**الحل**: التحقق من Namespace والمسارات

### الخطأ 5: View not found
**السبب**: الملف غير موجود أو المسار خاطئ
**الحل**: التحقق من وجود الملفات في `resources/views/shipment/`

### الخطأ 6: Foreign key constraint fails
**السبب**: محاولة حذف سجل مرتبط بسجلات أخرى
**الحل**: حذف السجلات المرتبطة أولاً

## 📋 قائمة التحقق (Checklist)

### ✅ قاعدة البيانات
- [ ] Migrations تم تشغيلها بنجاح
- [ ] جميع الجداول موجودة
- [ ] Foreign Keys تعمل بشكل صحيح

### ✅ الصلاحيات
- [ ] الصلاحيات موجودة في قاعدة البيانات
- [ ] الصلاحيات مربوطة بالأدوار
- [ ] التحقق من الصلاحيات يعمل

### ✅ Routes
- [ ] جميع Routes موجودة
- [ ] Routes تعمل بشكل صحيح
- [ ] Middleware يعمل

### ✅ Controllers
- [ ] جميع Controllers موجودة
- [ ] CRUD يعمل لكل Controller
- [ ] Validation يعمل
- [ ] Permission Checks تعمل

### ✅ Views
- [ ] جميع Views موجودة
- [ ] الصفحات تعرض بشكل صحيح
- [ ] Forms تعمل
- [ ] Tables تعرض البيانات

### ✅ Models
- [ ] جميع Models موجودة
- [ ] العلاقات تعمل
- [ ] Auto Calculate يعمل
- [ ] Scopes تعمل

### ✅ الوظائف الخاصة
- [ ] توليد رقم الطلب تلقائياً
- [ ] حساب السعر الإجمالي
- [ ] حساب الكمية المتاحة
- [ ] حساب حجم الصندوق

## 🎯 سيناريو اختبار كامل

### السيناريو 1: إنشاء طلب شحن كامل

1. **إنشاء شركة شحن:**
   - اذهب إلى Courier Companies → Create
   - أدخل البيانات
   - احفظ
   - ✅ يجب إنشاء الشركة بنجاح

2. **إنشاء بائع:**
   - اذهب إلى Sellers → Create
   - أدخل البيانات
   - احفظ
   - ✅ يجب إنشاء البائع بنجاح

3. **إنشاء مستودع (إذا لم يكن موجوداً):**
   - اذهب إلى Warehouse → Create
   - أدخل البيانات
   - احفظ

4. **إنشاء موقع مخزون:**
   - اذهب إلى Stock Locations → Create
   - اختر المستودع
   - أدخل Location Code
   - احفظ
   - ✅ يجب إنشاء الموقع بنجاح

5. **إنشاء عنصر:**
   - اذهب إلى Items → Create
   - أدخل Item Name و SKU
   - احفظ
   - ✅ يجب إنشاء العنصر بنجاح

6. **إضافة عنصر للمخزون:**
   - اذهب إلى Inventory → Create
   - اختر العنصر والمستودع والموقع
   - أدخل الكمية
   - احفظ
   - ✅ يجب إضافة العنصر للمخزون

7. **إنشاء طلب شحن:**
   - اذهب إلى Shipment Orders → Create
   - أدخل بيانات العميل
   - اختر شركة الشحن والبائع والمستودع
   - أضف عناصر للطلب
   - احفظ
   - ✅ يجب إنشاء الطلب بنجاح
   - ✅ يجب توليد رقم الطلب تلقائياً
   - ✅ يجب حساب السعر الإجمالي

8. **عرض الطلب:**
   - اذهب إلى Shipment Orders → View
   - ✅ يجب عرض جميع البيانات
   - ✅ يجب عرض العناصر

### السيناريو 2: اختبار المركبات والصناديق

1. **إنشاء مركبة:**
   - اذهب إلى Vehicles → Create
   - أدخل بيانات المركبة والسائق
   - احفظ
   - ✅ يجب إنشاء المركبة بنجاح

2. **إنشاء صندوق:**
   - اذهب إلى Boxes → Create
   - أدخل الأبعاد
   - احفظ
   - ✅ يجب حساب الحجم تلقائياً

## 🔍 أدوات الاختبار

### 1. Laravel Tinker
```bash
php artisan tinker
```

**أمثلة للاختبار:**
```php
// اختبار Model
\App\Models\ShipmentOrder::count();
\App\Models\CourierCompany::count();

// اختبار العلاقات
$order = \App\Models\ShipmentOrder::first();
$order->items;
$order->courierCompany;

// اختبار توليد رقم الطلب
\App\Models\ShipmentOrder::generateOrderNumber();
```

### 2. Log Files
```bash
tail -f storage/logs/laravel.log
```

### 3. Debugbar
- تأكد من تفعيل Debugbar في `.env`
- `APP_DEBUG=true`

## ✅ النتيجة المتوقعة

بعد إكمال جميع الاختبارات، يجب أن:
- ✅ جميع الصفحات تعمل
- ✅ جميع العمليات CRUD تعمل
- ✅ الصلاحيات تعمل
- ✅ العلاقات تعمل
- ✅ الوظائف الخاصة تعمل
- ✅ Validation يعمل
- ✅ Workspace Isolation يعمل

---

**التاريخ**: 2025-01-15  
**الإصدار**: 1.0

