# أوامر الاختبار - Test Commands

## 🔧 الأوامر المطلوبة للاختبار

### 1. إعداد البيئة

```bash
# التأكد من التواجد في مجلد المشروع
cd "J:\Downloads\ops\cloud agents\main-file"

# مسح Cache
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# تحديث Autoload
composer dump-autoload
```

### 2. قاعدة البيانات

```bash
# تشغيل Migrations
php artisan migrate

# التحقق من حالة Migrations
php artisan migrate:status

# Rollback آخر Migration (إذا لزم الأمر)
php artisan migrate:rollback --step=1
```

### 3. الصلاحيات

```bash
# إضافة الصلاحيات
php artisan db:seed --class=ShipmentPermissionSeeder

# إضافة جميع Seeders (اختياري)
php artisan db:seed
```

### 4. التحقق من Routes

```bash
# عرض جميع Routes
php artisan route:list

# البحث عن Routes محددة
php artisan route:list | findstr shipment
php artisan route:list | findstr courier
php artisan route:list | findstr seller
php artisan route:list | findstr stock-location
php artisan route:list | findstr vehicle
php artisan route:list | findstr box
```

### 5. اختبار Models

```bash
# فتح Tinker
php artisan tinker

# في Tinker:
\App\Models\CourierCompany::count()
\App\Models\Seller::count()
\App\Models\ShipmentOrder::count()
\App\Models\StockLocation::count()
\App\Models\ShipmentItemMaster::count()
\App\Models\ShipmentInventory::count()
\App\Models\ShipmentVehicle::count()
\App\Models\ShipmentBox::count()

# اختبار توليد رقم الطلب
\App\Models\ShipmentOrder::generateOrderNumber()
```

### 6. التحقق من الأخطاء

```bash
# عرض Logs
tail -f storage/logs/laravel.log

# أو في PowerShell
Get-Content storage/logs/laravel.log -Tail 50 -Wait
```

### 7. الاختبار السريع

```bash
# اختبار أن Laravel يعمل
php artisan --version

# اختبار الاتصال بقاعدة البيانات
php artisan tinker
DB::connection()->getPdo();
exit
```

## 📋 سكريبت PowerShell للاختبار السريع

انسخ والصق في PowerShell:

```powershell
# الانتقال للمجلد
cd "J:\Downloads\ops\cloud agents\main-file"

# مسح Cache
Write-Host "Clearing cache..." -ForegroundColor Yellow
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# تحديث Autoload
Write-Host "Updating autoload..." -ForegroundColor Yellow
composer dump-autoload

# التحقق من Routes
Write-Host "Checking routes..." -ForegroundColor Yellow
php artisan route:list | Select-String "shipment"

Write-Host "Done! Now run: php artisan migrate" -ForegroundColor Green
```

## ✅ التحقق السريع

بعد تشغيل الأوامر، افتح المتصفح واذهب إلى:

1. `/courier-companies` - يجب أن تعمل
2. `/sellers` - يجب أن تعمل  
3. `/shipment-orders` - يجب أن تعمل
4. `/stock-locations` - يجب أن تعمل
5. `/shipment-items` - يجب أن تعمل
6. `/shipment-inventory` - يجب أن تعمل
7. `/vehicles` - يجب أن تعمل
8. `/boxes` - يجب أن تعمل

إذا ظهرت جميع الصفحات بدون أخطاء، النظام يعمل بشكل صحيح! ✅

