<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentBox extends Model
{
    use HasFactory;

    protected $fillable = [
        'box_number',
        'box_type',
        'length',
        'width',
        'height',
        'weight_capacity',
        'volume',
        'price',
        'status',
        'notes',
        'workspace',
        'created_by',
    ];

    protected $casts = [
        'length' => 'decimal:2',
        'width' => 'decimal:2',
        'height' => 'decimal:2',
        'weight_capacity' => 'decimal:2',
        'volume' => 'decimal:2',
        'price' => 'decimal:2',
    ];

    /**
     * Calculate volume automatically
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($box) {
            if ($box->length && $box->width && $box->height) {
                $box->volume = $box->length * $box->width * $box->height;
            }
        });
    }

    /**
     * Scope to filter by workspace
     */
    public function scopeWorkspace($query, $workspace)
    {
        return $query->where('workspace', $workspace);
    }

    /**
     * Scope to filter by creator
     */
    public function scopeCreatedBy($query, $userId)
    {
        return $query->where('created_by', $userId);
    }
}

