<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentInventory extends Model
{
    use HasFactory;

    protected $fillable = [
        'item_sku',
        'item_name',
        'warehouse_id',
        'stock_location_id',
        'quantity',
        'reserved_quantity',
        'available_quantity',
        'min_stock_level',
        'max_stock_level',
        'notes',
        'workspace',
        'created_by',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'reserved_quantity' => 'integer',
        'available_quantity' => 'integer',
        'min_stock_level' => 'integer',
        'max_stock_level' => 'integer',
    ];

    /**
     * Calculate available quantity automatically
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($inventory) {
            $inventory->available_quantity = $inventory->quantity - $inventory->reserved_quantity;
        });
    }

    /**
     * Get the warehouse for this inventory
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    /**
     * Get the stock location for this inventory
     */
    public function stockLocation()
    {
        return $this->belongsTo(StockLocation::class);
    }

    /**
     * Get the item master data
     */
    public function itemMaster()
    {
        return $this->belongsTo(ShipmentItemMaster::class, 'item_sku', 'sku');
    }

    /**
     * Scope to filter by workspace
     */
    public function scopeWorkspace($query, $workspace)
    {
        return $query->where('workspace', $workspace);
    }
}

