<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'shipment_order_id',
        'item_name',
        'sku',
        'quantity',
        'weight',
        'price',
        'total_price',
        'description',
        'workspace',
        'created_by',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'weight' => 'decimal:2',
        'price' => 'decimal:2',
        'total_price' => 'decimal:2',
    ];

    /**
     * Get the shipment order for this item
     */
    public function shipmentOrder()
    {
        return $this->belongsTo(ShipmentOrder::class);
    }

    /**
     * Calculate total price automatically
     */
    protected static function boot()
    {
        parent::boot();

        static::saving(function ($item) {
            $item->total_price = $item->quantity * $item->price;
        });
    }
}

