<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentItemMaster extends Model
{
    use HasFactory;

    protected $table = 'shipment_items_master';

    protected $fillable = [
        'item_name',
        'sku',
        'description',
        'weight',
        'price',
        'barcode',
        'category',
        'status',
        'workspace',
        'created_by',
    ];

    protected $casts = [
        'weight' => 'decimal:2',
        'price' => 'decimal:2',
    ];

    /**
     * Get all inventory records for this item
     */
    public function inventory()
    {
        return $this->hasMany(ShipmentInventory::class, 'item_sku', 'sku');
    }

    /**
     * Scope to filter by workspace
     */
    public function scopeWorkspace($query, $workspace)
    {
        return $query->where('workspace', $workspace);
    }

    /**
     * Scope to filter by creator
     */
    public function scopeCreatedBy($query, $userId)
    {
        return $query->where('created_by', $userId);
    }
}

