<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockLocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'warehouse_id',
        'location_code',
        'shelf_code',
        'zone',
        'description',
        'status',
        'workspace',
        'created_by',
    ];

    /**
     * Get the warehouse for this stock location
     */
    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class);
    }

    /**
     * Get all inventory items in this location
     */
    public function inventoryItems()
    {
        return $this->hasMany(ShipmentInventory::class);
    }

    /**
     * Scope to filter by workspace
     */
    public function scopeWorkspace($query, $workspace)
    {
        return $query->where('workspace', $workspace);
    }

    /**
     * Scope to filter by creator
     */
    public function scopeCreatedBy($query, $userId)
    {
        return $query->where('created_by', $userId);
    }
}

