<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('shipment_orders'))
        {
            Schema::create('shipment_orders', function (Blueprint $table) {
                $table->id();
                $table->string('order_number')->unique();
                $table->string('customer_name');
                $table->string('customer_phone');
                $table->string('customer_email')->nullable();
                $table->text('customer_address');
                $table->text('delivery_address');
                $table->enum('order_status', [
                    'ORDER_GENERATED',
                    'ORDER_CREATED',
                    'PICK_LIST',
                    'PACKED',
                    'DISPATCHED',
                    'DELIVERY',
                    'MANIFEST',
                    'DELIVERED',
                    'RETURNED'
                ])->default('ORDER_GENERATED');
                $table->foreignId('courier_company_id')->nullable()->constrained('courier_companies')->onDelete('set null');
                $table->foreignId('seller_id')->nullable()->constrained('sellers')->onDelete('set null');
                $table->foreignId('warehouse_id')->nullable()->constrained('warehouses')->onDelete('set null');
                $table->decimal('total_amount', 10, 2)->default(0);
                $table->enum('payment_status', ['pending', 'paid', 'refunded'])->default('pending');
                $table->date('order_date')->nullable();
                $table->date('delivery_date')->nullable();
                $table->text('notes')->nullable();
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_orders');
    }
};

