<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('shipment_items_master'))
        {
            Schema::create('shipment_items_master', function (Blueprint $table) {
                $table->id();
                $table->string('item_name');
                $table->string('sku')->unique();
                $table->text('description')->nullable();
                $table->decimal('weight', 8, 2)->nullable();
                $table->decimal('price', 10, 2)->default(0);
                $table->string('barcode')->nullable();
                $table->string('category')->nullable();
                $table->enum('status', ['active', 'inactive'])->default('active');
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_items_master');
    }
};

