<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('shipment_inventory'))
        {
            Schema::create('shipment_inventory', function (Blueprint $table) {
                $table->id();
                $table->string('item_sku');
                $table->string('item_name');
                $table->foreignId('warehouse_id')->constrained('warehouses')->onDelete('cascade');
                $table->foreignId('stock_location_id')->nullable()->constrained('stock_locations')->onDelete('set null');
                $table->integer('quantity')->default(0);
                $table->integer('reserved_quantity')->default(0);
                $table->integer('available_quantity')->default(0);
                $table->integer('min_stock_level')->default(0);
                $table->integer('max_stock_level')->nullable();
                $table->text('notes')->nullable();
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
                
                $table->unique(['item_sku', 'warehouse_id', 'stock_location_id'], 'inventory_unique');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_inventory');
    }
};

