<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('shipment_vehicles'))
        {
            Schema::create('shipment_vehicles', function (Blueprint $table) {
                $table->id();
                $table->string('vehicle_number')->unique();
                $table->string('vehicle_type'); // truck, van, motorcycle, etc.
                $table->string('driver_name');
                $table->string('driver_phone');
                $table->string('driver_license')->nullable();
                $table->decimal('capacity_weight', 8, 2)->nullable();
                $table->decimal('capacity_volume', 8, 2)->nullable();
                $table->enum('status', ['active', 'inactive', 'maintenance'])->default('active');
                $table->text('notes')->nullable();
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_vehicles');
    }
};

