<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('shipment_boxes'))
        {
            Schema::create('shipment_boxes', function (Blueprint $table) {
                $table->id();
                $table->string('box_number')->unique();
                $table->string('box_type'); // small, medium, large, custom
                $table->decimal('length', 8, 2)->nullable();
                $table->decimal('width', 8, 2)->nullable();
                $table->decimal('height', 8, 2)->nullable();
                $table->decimal('weight_capacity', 8, 2)->nullable();
                $table->decimal('volume', 8, 2)->nullable();
                $table->decimal('price', 10, 2)->default(0);
                $table->enum('status', ['available', 'in_use', 'damaged', 'retired'])->default('available');
                $table->text('notes')->nullable();
                $table->integer('workspace')->nullable();
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shipment_boxes');
    }
};

