<?php

namespace Database\Seeders;

use App\Models\Permission;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;

class ShipmentPermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('type','super admin')->first();
        
        if(empty($admin))
        {
            $admin = User::first();
        }

        // Shipment Order Permissions
        $shipment_order_permissions = [
            'shipment order manage',
            'shipment order create',
            'shipment order edit',
            'shipment order delete',
            'shipment order show',
        ];

        // Courier Company Permissions
        $courier_company_permissions = [
            'courier company manage',
            'courier company create',
            'courier company edit',
            'courier company delete',
        ];

        // Seller Permissions
        $seller_permissions = [
            'seller manage',
            'seller create',
            'seller edit',
            'seller delete',
        ];

        // Stock Location Permissions
        $stock_location_permissions = [
            'stock location manage',
            'stock location create',
            'stock location edit',
            'stock location delete',
        ];

        // Item Permissions
        $item_permissions = [
            'shipment item manage',
            'shipment item create',
            'shipment item edit',
            'shipment item delete',
        ];

        // Inventory Permissions
        $inventory_permissions = [
            'inventory manage',
            'inventory create',
            'inventory edit',
            'inventory delete',
        ];

        // Vehicle Permissions
        $vehicle_permissions = [
            'vehicle manage',
            'vehicle create',
            'vehicle edit',
            'vehicle delete',
        ];

        // Box Permissions
        $box_permissions = [
            'box manage',
            'box create',
            'box edit',
            'box delete',
        ];

        // All shipment permissions
        $all_permissions = array_merge(
            $shipment_order_permissions,
            $courier_company_permissions,
            $seller_permissions,
            $stock_location_permissions,
            $item_permissions,
            $inventory_permissions,
            $vehicle_permissions,
            $box_permissions
        );

        // Super Admin Role
        $superAdminRole = Role::where('name','super admin')->first();
        
        foreach ($all_permissions as $permission_name)
        {
            $permission = Permission::where('name', $permission_name)->first();
            if(empty($permission))
            {
                $permission = Permission::create(
                    [
                        'name' => $permission_name,
                        'guard_name' => 'web',
                        'module' => 'General',
                        'created_by' => $admin->id,
                        "created_at" => date('Y-m-d H:i:s'),
                        "updated_at" => date('Y-m-d H:i:s')
                    ]
                );
            }
            if($superAdminRole && !$superAdminRole->hasPermission($permission_name))
            {
                $superAdminRole->givePermission($permission);
            }
        }

        // Company Role
        $company_role = Role::where('name','company')->where('guard_name','web')->first();
        
        if($company_role)
        {
            foreach ($all_permissions as $permission_name)
            {
                $permission = Permission::where('name', $permission_name)->first();
                if($permission && !$company_role->hasPermission($permission_name))
                {
                    $company_role->givePermission($permission);
                }
            }
        }
    }
}

