{{ Form::open(['url' => 'boxes', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate']) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-6">
            {{ Form::label('box_number', __('Box Number'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('box_number', '', ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Box Number']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('box_type', __('Box Type'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('box_type', [
                'small' => __('Small'),
                'medium' => __('Medium'),
                'large' => __('Large'),
                'custom' => __('Custom'),
            ], '', ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('length', __('Length (cm)'), ['class' => 'form-label']) }}
            {{ Form::number('length', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('width', __('Width (cm)'), ['class' => 'form-label']) }}
            {{ Form::number('width', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('height', __('Height (cm)'), ['class' => 'form-label']) }}
            {{ Form::number('height', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('weight_capacity', __('Weight Capacity (kg)'), ['class' => 'form-label']) }}
            {{ Form::number('weight_capacity', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('price', __('Price'), ['class' => 'form-label']) }}
            {{ Form::number('price', 0, ['class' => 'form-control', 'min' => 0, 'step' => 0.01]) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', [
                'available' => __('Available'),
                'in_use' => __('In Use'),
                'damaged' => __('Damaged'),
                'retired' => __('Retired'),
            ], 'available', ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('notes', __('Notes'), ['class' => 'form-label']) }}
            {{ Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => 'Enter Notes']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

