@extends('layouts.main')
@section('page-title')
    {{__('Manage Boxes')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Boxes')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('box create')
            <a data-size="lg" data-url="{{ route('boxes.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Box')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Box Number') }}</th>
                                    <th>{{ __('Box Type') }}</th>
                                    <th>{{ __('Dimensions') }}</th>
                                    <th>{{ __('Weight Capacity') }}</th>
                                    <th>{{ __('Volume') }}</th>
                                    <th>{{ __('Price') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('box edit') || \Auth::user()->isAbleTo('box delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($boxes as $index => $box)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $box->box_number }}</td>
                                    <td>{{ ucfirst($box->box_type) }}</td>
                                    <td>
                                        @if($box->length && $box->width && $box->height)
                                            {{ number_format($box->length, 2) }} x {{ number_format($box->width, 2) }} x {{ number_format($box->height, 2) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>{{ $box->weight_capacity ? number_format($box->weight_capacity, 2) . ' kg' : '-' }}</td>
                                    <td>{{ $box->volume ? number_format($box->volume, 2) . ' m³' : '-' }}</td>
                                    <td>{{ number_format($box->price, 2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $box->status == 'available' ? 'success' : ($box->status == 'in_use' ? 'info' : ($box->status == 'damaged' ? 'danger' : 'secondary')) }}">
                                            {{ ucfirst(str_replace('_', ' ', $box->status)) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('box edit') || \Auth::user()->isAbleTo('box delete'))
                                    <td>
                                        @include('shipment.boxes.action', ['box' => $box])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">{{ __('No boxes found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

