@extends('layouts.main')
@section('page-title')
    {{__('Manage Courier Companies')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Courier Companies')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('courier company create')
            <a data-size="lg" data-url="{{ route('courier-companies.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Courier Company')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Contact Person') }}</th>
                                    <th>{{ __('Phone') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('courier company show') || \Auth::user()->isAbleTo('courier company edit') || \Auth::user()->isAbleTo('courier company delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($courierCompanies as $index => $company)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $company->name }}</td>
                                    <td>{{ $company->contact_person ?? '-' }}</td>
                                    <td>{{ $company->phone ?? '-' }}</td>
                                    <td>{{ $company->email ?? '-' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $company->status == 'active' ? 'success' : 'danger' }}">
                                            {{ ucfirst($company->status) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('courier company show') || \Auth::user()->isAbleTo('courier company edit') || \Auth::user()->isAbleTo('courier company delete'))
                                    <td>
                                        @include('shipment.courier-companies.action', ['company' => $company])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('No courier companies found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

