{{ Form::open(['url' => 'shipment-inventory', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate']) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-6">
            {{ Form::label('item_sku', __('Item SKU'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('item_sku', $items->pluck('item_name', 'sku')->prepend(__('Select Item'), ''), '', ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('warehouse_id', __('Warehouse'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('warehouse_id', $warehouses->pluck('name', 'id')->prepend(__('Select Warehouse'), ''), '', ['class' => 'form-control', 'required' => 'required', 'id' => 'warehouse_id']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('stock_location_id', __('Stock Location'), ['class' => 'form-label']) }}
            {{ Form::select('stock_location_id', [], '', ['class' => 'form-control', 'id' => 'stock_location_id']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('quantity', __('Quantity'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::number('quantity', 0, ['class' => 'form-control', 'required' => 'required', 'min' => 0, 'step' => 1]) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('reserved_quantity', __('Reserved Quantity'), ['class' => 'form-label']) }}
            {{ Form::number('reserved_quantity', 0, ['class' => 'form-control', 'min' => 0, 'step' => 1]) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('min_stock_level', __('Min Stock Level'), ['class' => 'form-label']) }}
            {{ Form::number('min_stock_level', 0, ['class' => 'form-control', 'min' => 0, 'step' => 1]) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('max_stock_level', __('Max Stock Level'), ['class' => 'form-label']) }}
            {{ Form::number('max_stock_level', '', ['class' => 'form-control', 'min' => 0, 'step' => 1]) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('notes', __('Notes'), ['class' => 'form-label']) }}
            {{ Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => 'Enter Notes']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

{{-- Note: Location filtering can be added via AJAX route if needed --}}

