@extends('layouts.main')
@section('page-title')
    {{__('Manage Inventory')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Inventory')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('inventory create')
            <a data-size="lg" data-url="{{ route('shipment-inventory.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Add Inventory Item')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Item SKU') }}</th>
                                    <th>{{ __('Item Name') }}</th>
                                    <th>{{ __('Warehouse') }}</th>
                                    <th>{{ __('Location') }}</th>
                                    <th>{{ __('Quantity') }}</th>
                                    <th>{{ __('Reserved') }}</th>
                                    <th>{{ __('Available') }}</th>
                                    <th>{{ __('Min Level') }}</th>
                                    @if(\Auth::user()->isAbleTo('inventory edit') || \Auth::user()->isAbleTo('inventory delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($inventory as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $item->item_sku }}</td>
                                    <td>{{ $item->item_name }}</td>
                                    <td>{{ $item->warehouse->name ?? '-' }}</td>
                                    <td>{{ $item->stockLocation->location_code ?? '-' }}</td>
                                    <td>{{ $item->quantity }}</td>
                                    <td>{{ $item->reserved_quantity }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->available_quantity < $item->min_stock_level ? 'danger' : 'success' }}">
                                            {{ $item->available_quantity }}
                                        </span>
                                    </td>
                                    <td>{{ $item->min_stock_level }}</td>
                                    @if(\Auth::user()->isAbleTo('inventory edit') || \Auth::user()->isAbleTo('inventory delete'))
                                    <td>
                                        @include('shipment.inventory.action', ['item' => $item])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center">{{ __('No inventory items found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

