{{ Form::model($shipmentItem, array('route' => array('shipment-items.update', $shipmentItem->id), 'method' => 'PUT', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate')) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-12">
            {{ Form::label('item_name', __('Item Name'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('item_name', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Item Name']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('sku', __('SKU'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('sku', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter SKU']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('category', __('Category'), ['class' => 'form-label']) }}
            {{ Form::text('category', null, ['class' => 'form-control','placeholder' => 'Enter Category']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('weight', __('Weight (kg)'), ['class' => 'form-label']) }}
            {{ Form::number('weight', null, ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('price', __('Price'), ['class' => 'form-label']) }}
            {{ Form::number('price', null, ['class' => 'form-control', 'min' => 0, 'step' => 0.01]) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('barcode', __('Barcode'), ['class' => 'form-label']) }}
            {{ Form::text('barcode', null, ['class' => 'form-control','placeholder' => 'Enter Barcode']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', [
                'active' => __('Active'),
                'inactive' => __('Inactive'),
            ], $shipmentItem->status, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
            {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => 'Enter Description']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

