@extends('layouts.main')
@section('page-title')
    {{__('Manage Items')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Items')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('shipment item create')
            <a data-size="lg" data-url="{{ route('shipment-items.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Item')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Item Name') }}</th>
                                    <th>{{ __('SKU') }}</th>
                                    <th>{{ __('Category') }}</th>
                                    <th>{{ __('Weight') }}</th>
                                    <th>{{ __('Price') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('shipment item edit') || \Auth::user()->isAbleTo('shipment item delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($items as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $item->item_name }}</td>
                                    <td>{{ $item->sku }}</td>
                                    <td>{{ $item->category ?? '-' }}</td>
                                    <td>{{ $item->weight ? $item->weight . ' kg' : '-' }}</td>
                                    <td>{{ number_format($item->price, 2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->status == 'active' ? 'success' : 'danger' }}">
                                            {{ ucfirst($item->status) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('shipment item edit') || \Auth::user()->isAbleTo('shipment item delete'))
                                    <td>
                                        @include('shipment.items.action', ['item' => $item])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">{{ __('No items found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

