{{ Form::model($shipmentOrder, array('route' => array('shipment-orders.update', $shipmentOrder->id), 'method' => 'PUT', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate')) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-6">
            {{ Form::label('customer_name', __('Customer Name'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('customer_name', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Customer Name']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('customer_phone', __('Customer Phone'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('customer_phone', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Customer Phone']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('customer_email', __('Customer Email'), ['class' => 'form-label']) }}
            {{ Form::email('customer_email', null, ['class' => 'form-control','placeholder' => 'Enter Customer Email']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('order_status', __('Order Status'), ['class' => 'form-label']) }}
            {{ Form::select('order_status', [
                'ORDER_GENERATED' => __('Order Generated'),
                'ORDER_CREATED' => __('Order Created'),
                'PICK_LIST' => __('Pick List'),
                'PACKED' => __('Packed'),
                'DISPATCHED' => __('Dispatched'),
                'DELIVERY' => __('Delivery'),
                'MANIFEST' => __('Manifest'),
                'DELIVERED' => __('Delivered'),
                'RETURNED' => __('Returned'),
            ], $shipmentOrder->order_status, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('customer_address', __('Customer Address'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('customer_address', null, ['class' => 'form-control', 'rows' => 2, 'required' => 'required', 'placeholder' => 'Enter Customer Address']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('delivery_address', __('Delivery Address'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('delivery_address', null, ['class' => 'form-control', 'rows' => 2, 'required' => 'required', 'placeholder' => 'Enter Delivery Address']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('courier_company_id', __('Courier Company'), ['class' => 'form-label']) }}
            {{ Form::select('courier_company_id', $courierCompanies->pluck('name', 'id')->prepend(__('Select Courier Company'), ''), $shipmentOrder->courier_company_id, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('seller_id', __('Seller'), ['class' => 'form-label']) }}
            {{ Form::select('seller_id', $sellers->pluck('name', 'id')->prepend(__('Select Seller'), ''), $shipmentOrder->seller_id, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('warehouse_id', __('Warehouse'), ['class' => 'form-label']) }}
            {{ Form::select('warehouse_id', $warehouses->pluck('name', 'id')->prepend(__('Select Warehouse'), ''), $shipmentOrder->warehouse_id, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('order_date', __('Order Date'), ['class' => 'form-label']) }}
            {{ Form::date('order_date', $shipmentOrder->order_date ? $shipmentOrder->order_date->format('Y-m-d') : date('Y-m-d'), ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('delivery_date', __('Delivery Date'), ['class' => 'form-label']) }}
            {{ Form::date('delivery_date', $shipmentOrder->delivery_date ? $shipmentOrder->delivery_date->format('Y-m-d') : '', ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-4">
            {{ Form::label('payment_status', __('Payment Status'), ['class' => 'form-label']) }}
            {{ Form::select('payment_status', [
                'pending' => __('Pending'),
                'paid' => __('Paid'),
                'refunded' => __('Refunded'),
            ], $shipmentOrder->payment_status, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('notes', __('Notes'), ['class' => 'form-label']) }}
            {{ Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => 'Enter Notes']) }}
        </div>
        
        <div class="col-md-12">
            <h6 class="mb-3">{{ __('Items') }}</h6>
            <div id="items-container">
                @foreach($shipmentOrder->items as $index => $item)
                <div class="item-row mb-3 p-3 border rounded">
                    <div class="row">
                        <div class="form-group col-md-4">
                            {{ Form::label("items[$index][item_name]", __('Item Name'), ['class' => 'form-label']) }}
                            {{ Form::text("items[$index][item_name]", $item->item_name, ['class' => 'form-control', 'placeholder' => 'Enter Item Name']) }}
                        </div>
                        <div class="form-group col-md-2">
                            {{ Form::label("items[$index][sku]", __('SKU'), ['class' => 'form-label']) }}
                            {{ Form::text("items[$index][sku]", $item->sku, ['class' => 'form-control', 'placeholder' => 'SKU']) }}
                        </div>
                        <div class="form-group col-md-2">
                            {{ Form::label("items[$index][quantity]", __('Quantity'), ['class' => 'form-label']) }}
                            {{ Form::number("items[$index][quantity]", $item->quantity, ['class' => 'form-control quantity-input', 'min' => 1, 'step' => 1]) }}
                        </div>
                        <div class="form-group col-md-2">
                            {{ Form::label("items[$index][price]", __('Price'), ['class' => 'form-label']) }}
                            {{ Form::number("items[$index][price]", $item->price, ['class' => 'form-control price-input', 'min' => 0, 'step' => 0.01]) }}
                        </div>
                        <div class="form-group col-md-2">
                            {{ Form::label("items[$index][weight]", __('Weight'), ['class' => 'form-label']) }}
                            {{ Form::number("items[$index][weight]", $item->weight, ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => 'kg']) }}
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-danger remove-item-btn mt-2">
                        <i class="ti ti-trash"></i> {{ __('Remove') }}
                    </button>
                </div>
                @endforeach
            </div>
            <button type="button" class="btn btn-sm btn-secondary" id="add-item-btn">
                <i class="ti ti-plus"></i> {{ __('Add Item') }}
            </button>
        </div>
        
        <div class="form-group col-md-12 mt-3">
            {{ Form::label('total_amount', __('Total Amount'), ['class' => 'form-label']) }}
            {{ Form::number('total_amount', $shipmentOrder->total_amount, ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'id' => 'total_amount']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

<script>
    let itemIndex = {{ count($shipmentOrder->items) }};
    document.getElementById('add-item-btn').addEventListener('click', function() {
        const container = document.getElementById('items-container');
        const newItem = document.createElement('div');
        newItem.className = 'item-row mb-3 p-3 border rounded';
        newItem.innerHTML = `
            <div class="row">
                <div class="form-group col-md-4">
                    <label class="form-label">${'{{__("Item Name")}}'}</label>
                    <input type="text" name="items[${itemIndex}][item_name]" class="form-control" placeholder="${'{{__("Enter Item Name")}}'}">
                </div>
                <div class="form-group col-md-2">
                    <label class="form-label">${'{{__("SKU")}}'}</label>
                    <input type="text" name="items[${itemIndex}][sku]" class="form-control" placeholder="SKU">
                </div>
                <div class="form-group col-md-2">
                    <label class="form-label">${'{{__("Quantity")}}'}</label>
                    <input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity-input" value="1" min="1" step="1">
                </div>
                <div class="form-group col-md-2">
                    <label class="form-label">${'{{__("Price")}}'}</label>
                    <input type="number" name="items[${itemIndex}][price]" class="form-control price-input" value="0" min="0" step="0.01">
                </div>
                <div class="form-group col-md-2">
                    <label class="form-label">${'{{__("Weight")}}'}</label>
                    <input type="number" name="items[${itemIndex}][weight]" class="form-control" min="0" step="0.01" placeholder="kg">
                </div>
            </div>
            <button type="button" class="btn btn-sm btn-danger remove-item-btn mt-2">
                <i class="ti ti-trash"></i> ${'{{__("Remove")}}'}
            </button>
        `;
        container.appendChild(newItem);
        itemIndex++;
        
        newItem.querySelector('.remove-item-btn').addEventListener('click', function() {
            newItem.remove();
            calculateTotal();
        });
        
        newItem.querySelectorAll('.price-input, .quantity-input').forEach(input => {
            input.addEventListener('input', calculateTotal);
        });
    });
    
    function calculateTotal() {
        let total = 0;
        document.querySelectorAll('.item-row').forEach(row => {
            const quantity = parseFloat(row.querySelector('.quantity-input')?.value || 0);
            const price = parseFloat(row.querySelector('.price-input')?.value || 0);
            total += quantity * price;
        });
        document.getElementById('total_amount').value = total.toFixed(2);
    }
    
    document.querySelectorAll('.price-input, .quantity-input').forEach(input => {
        input.addEventListener('input', calculateTotal);
    });
    
    document.addEventListener('click', function(e) {
        if (e.target.closest('.remove-item-btn')) {
            e.target.closest('.item-row').remove();
            calculateTotal();
        }
    });
</script>

