@extends('layouts.main')
@section('page-title')
    {{__('Shipment Order Details')}}
@endsection

@push('scripts')
@endpush
@section('page-breadcrumb')
   {{__('Shipment Order Details')}}
@endsection
@section('action-btn')
    @permission('shipment order edit')
        <a class="btn btn-sm btn-primary" href="{{ route('shipment-orders.edit', $shipmentOrder->id) }}" data-ajax-popup="true" data-size="lg" data-title="{{ __('Edit Shipment Order') }}">
            <i class="ti ti-pencil"></i> {{ __('Edit') }}
        </a>
    @endpermission
@endsection

@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Order Information') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong>{{ __('Order Number') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->order_number }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>{{ __('Customer Name') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->customer_name }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>{{ __('Customer Phone') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->customer_phone }}</span>
                            </div>
                            @if($shipmentOrder->customer_email)
                            <div class="mb-3">
                                <strong>{{ __('Customer Email') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->customer_email }}</span>
                            </div>
                            @endif
                            <div class="mb-3">
                                <strong>{{ __('Order Status') }}:</strong>
                                <span class="ms-2 badge bg-primary">{{ str_replace('_', ' ', $shipmentOrder->order_status) }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>{{ __('Payment Status') }}:</strong>
                                <span class="ms-2 badge bg-{{ $shipmentOrder->payment_status == 'paid' ? 'success' : ($shipmentOrder->payment_status == 'refunded' ? 'danger' : 'warning') }}">
                                    {{ ucfirst($shipmentOrder->payment_status) }}
                                </span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong>{{ __('Order Date') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->order_date ? $shipmentOrder->order_date->format('Y-m-d') : '-' }}</span>
                            </div>
                            @if($shipmentOrder->delivery_date)
                            <div class="mb-3">
                                <strong>{{ __('Delivery Date') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->delivery_date->format('Y-m-d') }}</span>
                            </div>
                            @endif
                            @if($shipmentOrder->courierCompany)
                            <div class="mb-3">
                                <strong>{{ __('Courier Company') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->courierCompany->name }}</span>
                            </div>
                            @endif
                            @if($shipmentOrder->seller)
                            <div class="mb-3">
                                <strong>{{ __('Seller') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->seller->name }}</span>
                            </div>
                            @endif
                            @if($shipmentOrder->warehouse)
                            <div class="mb-3">
                                <strong>{{ __('Warehouse') }}:</strong>
                                <span class="ms-2">{{ $shipmentOrder->warehouse->name }}</span>
                            </div>
                            @endif
                            <div class="mb-3">
                                <strong>{{ __('Total Amount') }}:</strong>
                                <span class="ms-2 fw-bold">{{ number_format($shipmentOrder->total_amount, 2) }}</span>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3">
                                <strong>{{ __('Customer Address') }}:</strong>
                                <p class="ms-2">{{ $shipmentOrder->customer_address }}</p>
                            </div>
                            <div class="mb-3">
                                <strong>{{ __('Delivery Address') }}:</strong>
                                <p class="ms-2">{{ $shipmentOrder->delivery_address }}</p>
                            </div>
                            @if($shipmentOrder->notes)
                            <div class="mb-3">
                                <strong>{{ __('Notes') }}:</strong>
                                <p class="ms-2">{{ $shipmentOrder->notes }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Order Items') }}</h5>
                </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead>
                                <tr>
                                    <th>{{ __('Item Name') }}</th>
                                    <th>{{ __('SKU') }}</th>
                                    <th>{{ __('Quantity') }}</th>
                                    <th>{{ __('Weight') }}</th>
                                    <th>{{ __('Price') }}</th>
                                    <th>{{ __('Total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($shipmentOrder->items as $item)
                                <tr>
                                    <td>{{ $item->item_name }}</td>
                                    <td>{{ $item->sku ?? '-' }}</td>
                                    <td>{{ $item->quantity }}</td>
                                    <td>{{ $item->weight ? $item->weight . ' kg' : '-' }}</td>
                                    <td>{{ number_format($item->price, 2) }}</td>
                                    <td>{{ number_format($item->total_price, 2) }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">{{ __('No items found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="5" class="text-end fw-bold">{{ __('Total Amount') }}:</td>
                                    <td class="fw-bold">{{ number_format($shipmentOrder->total_amount, 2) }}</td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

