@extends('layouts.main')
@section('page-title')
    {{__('Manage Sellers')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Sellers')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('seller create')
            <a data-size="lg" data-url="{{ route('sellers.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Seller')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Company Name') }}</th>
                                    <th>{{ __('Phone') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('seller show') || \Auth::user()->isAbleTo('seller edit') || \Auth::user()->isAbleTo('seller delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($sellers as $index => $seller)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $seller->name }}</td>
                                    <td>{{ $seller->company_name ?? '-' }}</td>
                                    <td>{{ $seller->phone ?? '-' }}</td>
                                    <td>{{ $seller->email ?? '-' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $seller->status == 'active' ? 'success' : 'danger' }}">
                                            {{ ucfirst($seller->status) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('seller show') || \Auth::user()->isAbleTo('seller edit') || \Auth::user()->isAbleTo('seller delete'))
                                    <td>
                                        @include('shipment.sellers.action', ['seller' => $seller])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('No sellers found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

