{{ Form::model($stockLocation, array('route' => array('stock-locations.update', $stockLocation->id), 'method' => 'PUT', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate')) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-6">
            {{ Form::label('warehouse_id', __('Warehouse'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('warehouse_id', $warehouses->pluck('name', 'id')->prepend(__('Select Warehouse'), ''), $stockLocation->warehouse_id, ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('location_code', __('Location Code'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('location_code', null, ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Location Code']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('shelf_code', __('Shelf Code'), ['class' => 'form-label']) }}
            {{ Form::text('shelf_code', null, ['class' => 'form-control','placeholder' => 'Enter Shelf Code']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('zone', __('Zone'), ['class' => 'form-label']) }}
            {{ Form::text('zone', null, ['class' => 'form-control','placeholder' => 'Enter Zone']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', [
                'active' => __('Active'),
                'inactive' => __('Inactive'),
            ], $stockLocation->status, ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
            {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => 'Enter Description']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

