@extends('layouts.main')
@section('page-title')
    {{__('Manage Stock Locations')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Stock Locations')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('stock location create')
            <a data-size="lg" data-url="{{ route('stock-locations.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Stock Location')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Location Code') }}</th>
                                    <th>{{ __('Warehouse') }}</th>
                                    <th>{{ __('Shelf Code') }}</th>
                                    <th>{{ __('Zone') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('stock location edit') || \Auth::user()->isAbleTo('stock location delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stockLocations as $index => $location)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $location->location_code }}</td>
                                    <td>{{ $location->warehouse->name ?? '-' }}</td>
                                    <td>{{ $location->shelf_code ?? '-' }}</td>
                                    <td>{{ $location->zone ?? '-' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $location->status == 'active' ? 'success' : 'danger' }}">
                                            {{ ucfirst($location->status) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('stock location edit') || \Auth::user()->isAbleTo('stock location delete'))
                                    <td>
                                        @include('shipment.stock-locations.action', ['location' => $location])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">{{ __('No stock locations found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

