{{ Form::open(['url' => 'vehicles', 'enctype'=>'multipart/form-data','class' => 'needs-validation', 'novalidate']) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-6">
            {{ Form::label('vehicle_number', __('Vehicle Number'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('vehicle_number', '', ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Vehicle Number']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('vehicle_type', __('Vehicle Type'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::select('vehicle_type', [
                'truck' => __('Truck'),
                'van' => __('Van'),
                'motorcycle' => __('Motorcycle'),
                'car' => __('Car'),
                'other' => __('Other'),
            ], '', ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('driver_name', __('Driver Name'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('driver_name', '', ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Driver Name']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('driver_phone', __('Driver Phone'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('driver_phone', '', ['class' => 'form-control', 'required' => 'required','placeholder' => 'Enter Driver Phone']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('driver_license', __('Driver License'), ['class' => 'form-label']) }}
            {{ Form::text('driver_license', '', ['class' => 'form-control','placeholder' => 'Enter Driver License']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', [
                'active' => __('Active'),
                'inactive' => __('Inactive'),
                'maintenance' => __('Maintenance'),
            ], 'active', ['class' => 'form-control']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('capacity_weight', __('Capacity Weight (kg)'), ['class' => 'form-label']) }}
            {{ Form::number('capacity_weight', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('capacity_volume', __('Capacity Volume (m³)'), ['class' => 'form-label']) }}
            {{ Form::number('capacity_volume', '', ['class' => 'form-control', 'min' => 0, 'step' => 0.01, 'placeholder' => '0.00']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('notes', __('Notes'), ['class' => 'form-label']) }}
            {{ Form::textarea('notes', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => 'Enter Notes']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Create') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

