@extends('layouts.main')
@section('page-title')
    {{__('Manage Vehicles')}}
@endsection
@push('script-page')
@endpush
@section('page-breadcrumb')
  {{__('Vehicles')}}
@endsection
@section('page-action')
    <div class="d-flex">
        @stack('addButtonHook')
        @permission('vehicle create')
            <a data-size="lg" data-url="{{ route('vehicles.create') }}" data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Create')}}" data-title="{{__('Create Vehicle')}}"  class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection
@push('css')
@endpush
@section('content')
    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 pc-dt-simple">
                            <thead>
                                <tr>
                                    <th>{{ __('No') }}</th>
                                    <th>{{ __('Vehicle Number') }}</th>
                                    <th>{{ __('Vehicle Type') }}</th>
                                    <th>{{ __('Driver Name') }}</th>
                                    <th>{{ __('Driver Phone') }}</th>
                                    <th>{{ __('Capacity') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    @if(\Auth::user()->isAbleTo('vehicle edit') || \Auth::user()->isAbleTo('vehicle delete'))
                                    <th>{{ __('Action') }}</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($vehicles as $index => $vehicle)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $vehicle->vehicle_number }}</td>
                                    <td>{{ ucfirst($vehicle->vehicle_type) }}</td>
                                    <td>{{ $vehicle->driver_name }}</td>
                                    <td>{{ $vehicle->driver_phone }}</td>
                                    <td>
                                        @if($vehicle->capacity_weight)
                                            {{ number_format($vehicle->capacity_weight, 2) }} kg
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $vehicle->status == 'active' ? 'success' : ($vehicle->status == 'maintenance' ? 'warning' : 'danger') }}">
                                            {{ ucfirst($vehicle->status) }}
                                        </span>
                                    </td>
                                    @if(\Auth::user()->isAbleTo('vehicle edit') || \Auth::user()->isAbleTo('vehicle delete'))
                                    <td>
                                        @include('shipment.vehicles.action', ['vehicle' => $vehicle])
                                    </td>
                                    @endif
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">{{ __('No vehicles found') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

