<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsDeviceMalwareState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\ManagedTenants\Model;

/**
* WindowsDeviceMalwareState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsDeviceMalwareState extends \Beta\Microsoft\Graph\Model\Entity
{
    /**
    * Gets the additionalInformationUrl
    * The additional information URL for the discovered malware. Optional. Read-only.
    *
    * @return string|null The additionalInformationUrl
    */
    public function getAdditionalInformationUrl()
    {
        if (array_key_exists("additionalInformationUrl", $this->_propDict)) {
            return $this->_propDict["additionalInformationUrl"];
        } else {
            return null;
        }
    }

    /**
    * Sets the additionalInformationUrl
    * The additional information URL for the discovered malware. Optional. Read-only.
    *
    * @param string $val The additionalInformationUrl
    *
    * @return WindowsDeviceMalwareState
    */
    public function setAdditionalInformationUrl($val)
    {
        $this->_propDict["additionalInformationUrl"] = $val;
        return $this;
    }

    /**
    * Gets the detectionCount
    * The number of times the piece of malware has been detected. Optional. Read-only.
    *
    * @return int|null The detectionCount
    */
    public function getDetectionCount()
    {
        if (array_key_exists("detectionCount", $this->_propDict)) {
            return $this->_propDict["detectionCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the detectionCount
    * The number of times the piece of malware has been detected. Optional. Read-only.
    *
    * @param int $val The detectionCount
    *
    * @return WindowsDeviceMalwareState
    */
    public function setDetectionCount($val)
    {
        $this->_propDict["detectionCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the deviceDeleted
    * A flag indicating whether the device has been deleted. Optional. Read-only.
    *
    * @return bool|null The deviceDeleted
    */
    public function getDeviceDeleted()
    {
        if (array_key_exists("deviceDeleted", $this->_propDict)) {
            return $this->_propDict["deviceDeleted"];
        } else {
            return null;
        }
    }

    /**
    * Sets the deviceDeleted
    * A flag indicating whether the device has been deleted. Optional. Read-only.
    *
    * @param bool $val The deviceDeleted
    *
    * @return WindowsDeviceMalwareState
    */
    public function setDeviceDeleted($val)
    {
        $this->_propDict["deviceDeleted"] = boolval($val);
        return $this;
    }

    /**
    * Gets the initialDetectionDateTime
    * The date and time the piece of malware was initially detected. Optional. Read-only.
    *
    * @return \DateTime|null The initialDetectionDateTime
    */
    public function getInitialDetectionDateTime()
    {
        if (array_key_exists("initialDetectionDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["initialDetectionDateTime"], "\DateTime") || is_null($this->_propDict["initialDetectionDateTime"])) {
                return $this->_propDict["initialDetectionDateTime"];
            } else {
                $this->_propDict["initialDetectionDateTime"] = new \DateTime($this->_propDict["initialDetectionDateTime"]);
                return $this->_propDict["initialDetectionDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the initialDetectionDateTime
    * The date and time the piece of malware was initially detected. Optional. Read-only.
    *
    * @param \DateTime $val The initialDetectionDateTime
    *
    * @return WindowsDeviceMalwareState
    */
    public function setInitialDetectionDateTime($val)
    {
        $this->_propDict["initialDetectionDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the lastRefreshedDateTime
    * Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
    *
    * @return \DateTime|null The lastRefreshedDateTime
    */
    public function getLastRefreshedDateTime()
    {
        if (array_key_exists("lastRefreshedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastRefreshedDateTime"], "\DateTime") || is_null($this->_propDict["lastRefreshedDateTime"])) {
                return $this->_propDict["lastRefreshedDateTime"];
            } else {
                $this->_propDict["lastRefreshedDateTime"] = new \DateTime($this->_propDict["lastRefreshedDateTime"]);
                return $this->_propDict["lastRefreshedDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastRefreshedDateTime
    * Date and time the entity was last updated in the multi-tenant management platform. Optional. Read-only.
    *
    * @param \DateTime $val The lastRefreshedDateTime
    *
    * @return WindowsDeviceMalwareState
    */
    public function setLastRefreshedDateTime($val)
    {
        $this->_propDict["lastRefreshedDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the lastStateChangeDateTime
    * The date and time the malware state was last changed. Optional. Read-only.
    *
    * @return \DateTime|null The lastStateChangeDateTime
    */
    public function getLastStateChangeDateTime()
    {
        if (array_key_exists("lastStateChangeDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastStateChangeDateTime"], "\DateTime") || is_null($this->_propDict["lastStateChangeDateTime"])) {
                return $this->_propDict["lastStateChangeDateTime"];
            } else {
                $this->_propDict["lastStateChangeDateTime"] = new \DateTime($this->_propDict["lastStateChangeDateTime"]);
                return $this->_propDict["lastStateChangeDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastStateChangeDateTime
    * The date and time the malware state was last changed. Optional. Read-only.
    *
    * @param \DateTime $val The lastStateChangeDateTime
    *
    * @return WindowsDeviceMalwareState
    */
    public function setLastStateChangeDateTime($val)
    {
        $this->_propDict["lastStateChangeDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the malwareCategory
    * The category for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareCategory
    */
    public function getMalwareCategory()
    {
        if (array_key_exists("malwareCategory", $this->_propDict)) {
            return $this->_propDict["malwareCategory"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareCategory
    * The category for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareCategory
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareCategory($val)
    {
        $this->_propDict["malwareCategory"] = $val;
        return $this;
    }

    /**
    * Gets the malwareDisplayName
    * The display name for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareDisplayName
    */
    public function getMalwareDisplayName()
    {
        if (array_key_exists("malwareDisplayName", $this->_propDict)) {
            return $this->_propDict["malwareDisplayName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareDisplayName
    * The display name for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareDisplayName
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareDisplayName($val)
    {
        $this->_propDict["malwareDisplayName"] = $val;
        return $this;
    }

    /**
    * Gets the malwareExecutionState
    * The execution state for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareExecutionState
    */
    public function getMalwareExecutionState()
    {
        if (array_key_exists("malwareExecutionState", $this->_propDict)) {
            return $this->_propDict["malwareExecutionState"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareExecutionState
    * The execution state for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareExecutionState
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareExecutionState($val)
    {
        $this->_propDict["malwareExecutionState"] = $val;
        return $this;
    }

    /**
    * Gets the malwareId
    * The unique identifier for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareId
    */
    public function getMalwareId()
    {
        if (array_key_exists("malwareId", $this->_propDict)) {
            return $this->_propDict["malwareId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareId
    * The unique identifier for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareId
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareId($val)
    {
        $this->_propDict["malwareId"] = $val;
        return $this;
    }

    /**
    * Gets the malwareSeverity
    * The severity for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareSeverity
    */
    public function getMalwareSeverity()
    {
        if (array_key_exists("malwareSeverity", $this->_propDict)) {
            return $this->_propDict["malwareSeverity"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareSeverity
    * The severity for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareSeverity
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareSeverity($val)
    {
        $this->_propDict["malwareSeverity"] = $val;
        return $this;
    }

    /**
    * Gets the malwareThreatState
    * The threat state for the detected malware. Optional. Read-only.
    *
    * @return string|null The malwareThreatState
    */
    public function getMalwareThreatState()
    {
        if (array_key_exists("malwareThreatState", $this->_propDict)) {
            return $this->_propDict["malwareThreatState"];
        } else {
            return null;
        }
    }

    /**
    * Sets the malwareThreatState
    * The threat state for the detected malware. Optional. Read-only.
    *
    * @param string $val The malwareThreatState
    *
    * @return WindowsDeviceMalwareState
    */
    public function setMalwareThreatState($val)
    {
        $this->_propDict["malwareThreatState"] = $val;
        return $this;
    }

    /**
    * Gets the managedDeviceId
    * The identifier for the managed device where the malware was detected. Optional. Read-only.
    *
    * @return string|null The managedDeviceId
    */
    public function getManagedDeviceId()
    {
        if (array_key_exists("managedDeviceId", $this->_propDict)) {
            return $this->_propDict["managedDeviceId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the managedDeviceId
    * The identifier for the managed device where the malware was detected. Optional. Read-only.
    *
    * @param string $val The managedDeviceId
    *
    * @return WindowsDeviceMalwareState
    */
    public function setManagedDeviceId($val)
    {
        $this->_propDict["managedDeviceId"] = $val;
        return $this;
    }

    /**
    * Gets the managedDeviceName
    * The display name for the managed device where the malware was detected. Optional. Read-only.
    *
    * @return string|null The managedDeviceName
    */
    public function getManagedDeviceName()
    {
        if (array_key_exists("managedDeviceName", $this->_propDict)) {
            return $this->_propDict["managedDeviceName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the managedDeviceName
    * The display name for the managed device where the malware was detected. Optional. Read-only.
    *
    * @param string $val The managedDeviceName
    *
    * @return WindowsDeviceMalwareState
    */
    public function setManagedDeviceName($val)
    {
        $this->_propDict["managedDeviceName"] = $val;
        return $this;
    }

    /**
    * Gets the tenantDisplayName
    * The display name for the managed tenant. Optional. Read-only.
    *
    * @return string|null The tenantDisplayName
    */
    public function getTenantDisplayName()
    {
        if (array_key_exists("tenantDisplayName", $this->_propDict)) {
            return $this->_propDict["tenantDisplayName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the tenantDisplayName
    * The display name for the managed tenant. Optional. Read-only.
    *
    * @param string $val The tenantDisplayName
    *
    * @return WindowsDeviceMalwareState
    */
    public function setTenantDisplayName($val)
    {
        $this->_propDict["tenantDisplayName"] = $val;
        return $this;
    }

    /**
    * Gets the tenantId
    * The Microsoft Entra tenant identifier for the managed tenant. Optional. Read-only.
    *
    * @return string|null The tenantId
    */
    public function getTenantId()
    {
        if (array_key_exists("tenantId", $this->_propDict)) {
            return $this->_propDict["tenantId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the tenantId
    * The Microsoft Entra tenant identifier for the managed tenant. Optional. Read-only.
    *
    * @param string $val The tenantId
    *
    * @return WindowsDeviceMalwareState
    */
    public function setTenantId($val)
    {
        $this->_propDict["tenantId"] = $val;
        return $this;
    }

}
